<?php

/* -------------------------------------------------------
 Enqueue CSS from child theme style.css
-------------------------------------------------------- */


function crum_child_css() {
	wp_enqueue_style( 'child-style', get_stylesheet_uri() );
}

add_action( 'wp_enqueue_scripts', 'crum_child_css', 99 );

// Change "In Stock" text but keep the quantity number
add_filter( 'woocommerce_get_availability_text', 'custom_in_stock_message_with_quantity', 20, 2 );
function custom_in_stock_message_with_quantity( $availability, $product ) {
    if ( $product->is_in_stock() ) {
        $availability = sprintf( __('(%s) Spots Available', 'woocommerce'), $product->get_stock_quantity() );
    }
    return $availability;
}

// Change "Related Products" text
add_filter( 'woocommerce_product_related_products_heading', 'custom_related_products_text' );
function custom_related_products_text( $translated_text ) {
    $translated_text = __( 'Group Sessions', 'woocommerce' ); // Your custom text here
    return $translated_text;
}


// Change "Product Description" text
add_filter( 'woocommerce_product_description_heading', 'custom_product_description_heading' );
function custom_product_description_heading( $heading ) {
    $heading = 'Group Session Details'; // Replace 'Details' with your desired text
    return $heading;
}


/* -------------------------------------------------------
 You can add your custom functions below
-------------------------------------------------------- */
